package com.agilex.healthcare.adr.model;

import com.agilex.healthcare.mobilehealthplatform.adr.AdrConfiguration;
import com.agilex.soap.Element;
import com.agilex.soap.Message;

public class GetEESummaryRequest {
	private static final String BODY_PREFIX = "sch";
	private static final String HEADER_PREFIX = "wsse";
	private static final String BODY_NAMESPACE = "http://jaxws.webservices.esr.domain.ext/schemas";
	private static final String HEADER_NAMESPACE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
	private static final String PW_NAMESPACE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText";
	
	private static final String USERNAME_TOKEN_PREFIX = "xmlns:wsu";
	private static final String USERNAME_TOKEN_NAMESPACE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";

	private AdrConfiguration configuration;
	private Message message = new Message();

	public GetEESummaryRequest(AdrConfiguration configuration) {
		this.configuration = configuration;
	}

	public Message build(String patientId) {
		message.addNamespace(BODY_PREFIX, BODY_NAMESPACE);

		addEeRequestBody(patientId, "VPID", configuration.getRequestName());
		addEeRequestHeader(configuration.getUsername(), configuration.getPassword());

		return message;
	}

	void addEeRequestBody(String key, String keyType, String requestName) {
		Element body = message.getBody().addChild("getEESummaryRequest", BODY_PREFIX, BODY_NAMESPACE);

		body.addChild("key", BODY_PREFIX, BODY_NAMESPACE).addElementValue(key);
		body.addChild("keyType", BODY_PREFIX, BODY_NAMESPACE).addElementValue(keyType);
		body.addChild("requestName", BODY_PREFIX, BODY_NAMESPACE).addElementValue(requestName);
	}

	void addEeRequestHeader(String username, String password) {
		Element header = message.getHeader();
		Element security = header.addChild("Security", HEADER_PREFIX, HEADER_NAMESPACE);
		security.addAttribute("mustUnderstand", "1");

		Element token = security.addChild("UsernameToken", HEADER_PREFIX, HEADER_NAMESPACE);
		token.addAttribute(USERNAME_TOKEN_PREFIX, USERNAME_TOKEN_NAMESPACE);
		token.addChild("Username", HEADER_PREFIX, HEADER_NAMESPACE).addElementValue(configuration.getUsername());

		Element passwordElement = token.addChild("Password", HEADER_PREFIX, HEADER_NAMESPACE).addElementValue(configuration.getPassword());
		passwordElement.addAttribute("Type", PW_NAMESPACE);
	}
}
